/**
* \file: UsbKeyboardInput.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Aauto - Test
*
* \author: M. Adachi / ADIT/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/prctl.h>
#include <linux/input.h>
#include <adit_typedef.h>
#include <adit_logging.h>
#include "UsbKeyboardInput.h"


LOG_DECLARE_CONTEXT(demo);

namespace adit { namespace aauto
{
USBKeyboardInput::~USBKeyboardInput()
{
    // KeyEvent polling stops  
    keyboard.Stop();

    LOGD_DEBUG((demo, "USBKeyboard de-initialization is done."));
}

void USBKeyboardInput::addSupportCode(eventTypeCode typeCode, uint16_t inKeyCode, uint32_t inInputCode)
{
    eventCodeBlock codeBlock = {inInputCode, typeCode};
    inputMap.insert(std::map<uint16_t, eventCodeBlock>::value_type(inKeyCode, codeBlock));
    if(typeCode == InputEventType)
    {
        keycodes.insert(inInputCode);
    }
}

bool USBKeyboardInput::convertKeycode(uint16_t inKeyCode, eventTypeCode& outTypeCode, uint32_t& outInputCode)
{
    bool rc = false;

    outInputCode = 0;
    std::map<uint16_t, eventCodeBlock>::iterator it = inputMap.find(inKeyCode);

    if(it != inputMap.end())
    {
        eventCodeBlock evt = it->second;
        outInputCode = evt.inputCode;
        outTypeCode = evt.typeCode;
        rc = true;
    }

    return rc;
}

void USBKeyboardInput::shutdown()
{
    LOG_INFO((demo, "USBKeyboardInput shut down"));
    // KeyEvent polling stops  
    keyboard.Stop();

    LOGD_DEBUG((demo, "USBKeyboard shutdown is done."));
}

bool USBKeyboardInput::init(IKeyEventCallback* inEventCallback)
{
    eventCallback = inEventCallback;
    
    // KeyEvent polling starts  
    keyboard.Start(this);

    LOGD_DEBUG((demo, "USBKeyboard initialization is success."));

    return true;
}

void USBKeyboardInput::OnKey(uint16_t inKeyCode, bool inPressed)
{
    eventTypeCode   outTypeCode;
    uint32_t        outInputCode;

    if(convertKeycode(inKeyCode, outTypeCode, outInputCode))
    {
        if(outTypeCode == InputEventType)
        {
            eventCallback->onKeyEventInput(outInputCode, inPressed);
        }
        else if(outTypeCode == VideoEventType)
        {
            if(inPressed) eventCallback->onKeyEventVideo(outInputCode);
        }
        else if(outTypeCode == DeviceSelectionType)
        {
            if(inPressed) eventCallback->onKeyEventDeviceSelection(outInputCode);
        }
        else if(outTypeCode == MediaActionType)
        {
            if(inPressed) eventCallback->onKeyEventMediaAction(outInputCode);
        }
        else
        {
            LOG_INFO((demo, "Could not find typecode (code:%d).", outTypeCode));
        }
    }
    else
    {
        LOG_INFO((demo, "Could not find Keycode (code:%d).", inKeyCode));
    }
}

void USBKeyboardInput::display()
{
    if(!keyboard.getDetection())
    {
        return;
    }

    printf("----------------------------------------------------\n");
    printf(" Assigned Keycode for demo.                         \n");
    printf("----------------------------------------------------\n");
    printf(" [Audio Control]                                    \n");
    printf("   Prev  -  \"a\" key                               \n");
    printf("   Play  -  \"s\" key                               \n");
    printf("   Pause -  \"d\" key                               \n");
    printf("   Next  -  \"f\" key                               \n");
    printf("   Trigger voice recognition -  \"v\" key           \n");
    printf(" [SetVideoFocus]                                    \n");
    printf("   Projection - \"p\" key                           \n");
    printf("   Native -     \"n\" key                           \n");
    printf(" [Select device]                                    \n");
    printf("   1st device-  \"1\" key                           \n");
    printf("   2nd device-  \"2\" key                           \n");
    printf(" [Media browser]                                    \n");
    printf("   Call mediaGetNode - \"z\" key                    \n");
    printf("----------------------------------------------------\n");
}

} } // namespace adit { namespace aauto
